// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_EI_H
#define HW_EI_H

#include "hw_internal.h"

class HwEI {
public:
	static void ww_sr(Hardware *h, WORD offset, DWORD data);
	static void ww_cr(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_sr(Hardware *h, WORD offset);
	static WORD rh_sr_low(Hardware *h, WORD offset);
	//template<DWORD slot> static void ext_event(Hardware *h);
	//template<DWORD slot> static void exi_event(Hardware *h);
private:
	static WORD getDCBit(Hardware *h, int channel);
};

int getEXISelection(DWORD status);
enum EXIResultValue { EXI_UNHANDLED, EXI_HANDLED };
enum EXITransferType { EXI_READ, EXI_WRITE, EXI_RW, EXI_UNDEFINED };
#define EIDEGUB if(g::exi_log) DEGUB
#define EXI_DEGUB if(!exi_devices[channel][device] || g::exi_log) DEGUB
//#define EXI_01_DEGUB_CONDITION (!g::advanced_mode || g::verbose)
#define EXI_01_DEGUB_CONDITION (g::exi_log)

class EXIDevice {
public:
	EXIDevice() {}
	virtual ~EXIDevice() {}

	virtual EXIResultValue writeImm(DWORD size, DWORD data) = 0;
	virtual EXIResultValue writeDMA(DWORD size, DWORD address, MemInterface &mem) = 0;
	virtual EXIResultValue readImm(DWORD size, DWORD &data) = 0;
	virtual EXIResultValue readDMA(DWORD size, DWORD address, MemInterface &mem) = 0;

	//virtual void notify_selected() = 0;
	virtual void notify_deselected() = 0;
	virtual bool pause() { return true; }
	virtual bool resume() { return true; }
};

#define EXI_STATUS(ch)	WORD(0x6800 + ch*0x14)
#define EXI_DMABUF(ch)	WORD(0x6804 + ch*0x14)
#define EXI_DMALEN(ch)	WORD(0x6808 + ch*0x14)
#define EXI_CONTROL(ch)	WORD(0x680C + ch*0x14)
#define EXI_IMMDAT(ch)	WORD(0x6810 + ch*0x14)

inline BYTE EXI_CHANNEL_FROM_OFFSET(WORD offset) {
	MYASSERT(offset >= 0x6800 && offset < (0x6800 + 0x14*3));
	return BYTE((offset - 0x6800) / 0x14);
}

#define EXI_DEVTYPE_MEMORY_CARD_59	0x00000004
#define EXI_DEVTYPE_MEMORY_CARD_123	0x00000008
#define EXI_DEVTYPE_MEMORY_CARD_251	0x00000010
#define EXI_DEVTYPE_MEMORY_CARD_507	0x00000020
#define EXI_DEVTYPE_MEMORY_CARD_1019	0x00000040
#define EXI_DEVTYPE_MEMORY_CARD_2043	0x00000080
#define EXI_DEVTYPE_AD16		0x04120000
#define EXI_DEVTYPE_USB_ADAPTER		0x01010000
#define EXI_DEVTYPE_IS_VIEWER		0x05070000
#define EXI_DEVTYPE_MODEM		0x02020000
#define EXI_DEVTYPE_ETHER		0x04020200

#define EICSR_EXTINT	0x00000800
#define EICSR_EXTINTMSK	0x00000400
#define EICSR_TCINT	0x00000008
#define EICSR_TCINTMSK	0x00000004
#define EICSR_EXIINT	0x00000002
#define EICSR_EXIINTMSK	0x00000001

#define EICR_TSTART	0x00000001
#define EICR_DMA	0x00000002

#endif	//HW_EI_H
